/*****************************************************************************
*  LPC11U6x RC5 encoder program
*
*  Use SCT1 timer to send encoded RC5 frames
*****************************************************************************/
#include "LPC11U6x.h"
#include "global.h"

void SysTick_Handler(void)                                     // just used to wake-up from sleep mode
{
}

int main (void) 
{
  static uint8_t  trg = 1;
  static uint8_t  tgl = 1;
  static uint16_t frame;

    LPC_SYSCON->SYSAHBCLKCTRL |= (1u << 16)                    // enable clock for IOCON
                               | (1u << 31);                   // enable clock for SCT0/1

    LPC_IOCON->PIO2_8  = 0x00000081;                           // P2_8  is SCT1_IN0
    LPC_IOCON->PIO2_16 = 0x00000081;                           // P2_16 is SCT1_OUT0

    RC5_Init();
    SysTick_Config(SystemCoreClock/8);                         // SysTick interrupt @ 1/8 sec

    while (1)
    {
        frame = (1   << 13) |                                  // set start (S) bit
                (1   << 12) |                                  // set field (F) bit
                (tgl << 11) |                                  // clr control / toggle (C) bit
                (20  << 6 ) |                                  // system  = 20
                (9   << 0 );                                   // command = 9

        if (!(LPC_GPIO_PORT->PIN[0] & (1 << 1)))               // P0.1 high to low?
        {
            if (trg)
            {
                trg = 0;                                       // trigger P0.1 low
            }
            RC5_Send(frame);
        }
        else if ((LPC_GPIO_PORT->PIN[0] & (1 << 1)) && !trg)   // P0.1 low to high?
        {
            trg = 1;                                           // trigger P0.1 high
            tgl = !tgl;                                        // toggle  P0.1 high
        }

        __wfi();                                               // goto sleep
    }
}
